---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-Staged Rendering

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/app-render/staged-rendering.ts` - StagedRenderingController実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RenderStage列挙型にBefore/Static/Runtime/Dynamic/Abandonedの5段階 | E-01 (4-10行目) | ○ |
| C-02 | コンストラクタでabortSignalリスナーを設定 | E-01 (34-52行目) | ○ |
| C-03 | mayAbandonがabortSignal存在時にtrue | E-01 (54行目) | ○ |
| C-04 | onStageでリスナー登録またはコールバック即時実行 | E-01 (58-69行目) | ○ |
| C-05 | canSyncInterruptでBefore時はfalse | E-01 (73行目) | ○ |
| C-06 | boundaryStageがhasRuntimePrefetchで変わる | E-01 (77-80行目) | ○ |
| C-07 | syncInterruptCurrentStageWithReasonのmayAbandon分岐 | E-01 (91-93行目) | ○ |
| C-08 | Static中断時にstaticInterruptReasonを記録しDynamicへ遷移 | E-01 (98-101行目) | ○ |
| C-09 | Runtime中断時にhasRuntimePrefetchの場合のみ中断 | E-01 (110-113行目) | ○ |
| C-10 | abandonRenderImplのStatic→Abandoned遷移 | E-01 (160-163行目) | ○ |
| C-11 | advanceStageの後方遷移無視 | E-01 (184行目) | ○ |
| C-12 | staticStageEndTimeをperformance.now+timeOriginで記録 | E-01 (192行目) | ○ |
| C-13 | resolveRuntimeStageでリスナー通知とPromise解決 | E-01 (203-209行目) | ○ |
| C-14 | delayUntilStageでDevtools対応Promiseを生成 | E-01 (241-261行目) | ○ |
| C-15 | makeDevtoolsIOPromiseFromIOTriggerでdisplayNameを設定 | E-01 (282-285行目) | ○ |
| C-16 | ignoreRejectでunhandled rejection抑制 | E-01 (264行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全コードが単一ファイルに収まっており、網羅的に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] StagedRenderingControllerが実際にどのように使われるか、app-render呼び出し元を確認
- [ ] Abandoned状態からのリトライレンダリングフローを確認
